##########################################################################
##                                                                      ##
##  I N T E R S T E L L A R   C O N S O L E  Update config.ini for ISC  ##
##                                                                      ##
##            Copyright (C) 2025- Misato Observatory, Wakayama, Japan   ##
##                                                                      ##
##  This software is available under the GPL (General Public License)   ##
##                                                                      ##
##########################################################################

set fullpath_of_config_ini ""
if { 0 < $argc } {
  set fullpath_of_config_ini [regsub -all {\\} [lindex $argv 0] {/}]
}

puts "Info: fullpath_of_config_ini = $fullpath_of_config_ini"

if { $fullpath_of_config_ini ne "" } {

  set lst [split $fullpath_of_config_ini "/"]

  set flg_found_config_ini 0

  # Confirm config.ini.  Create directories if not found them.
  #
  set tmp_path ""
  set len_lst [llength $lst]
  for {set i 0} {$i < $len_lst} {incr i} {
    set v [lindex $lst $i]
    append tmp_path "$v"
    #puts "tmp_path: $tmp_path"
    set flg_drive 0
    if { $i == 0 && [string length $v] == 2 && [string index $v 1] eq ":" } {
      # This is a DRIVE
      set flg_drive 1
    } else {
      # This is a directory or a file
      if { [expr $i + 1] == $len_lst } {
        if { [file isfile $tmp_path] == 1 } {
          set flg_found_config_ini 1
        } else {
          set flg_found_config_ini 0
        }
        break
      } else {
        if { [file isdirectory $tmp_path] == 0 } {
          puts "Info: mkdir $tmp_path"
          file mkdir $tmp_path
        }
      }
    }
    append tmp_path "/"
  }

  #puts "tmp_path: $tmp_path"

  array set lines_config_ini {}

  # Read all lines of config.ini
  #
  if { 1 } {

    set len_lines 0
    if { $flg_found_config_ini != 0 } {
      if { [catch {open $fullpath_of_config_ini r} fid] } {
        set len_lines 0
      } else {
        set i 0
        while { [gets $fid line] >= 0 } {
          set lines_config_ini($i) $line
          incr i
        }
        close $fid
        set len_lines $i
      }
    }

    # test existence of section
    #
    set flg_section_plugins_load_at_startup 0
    set flg_section_RemoteControl 0
    set flg_section_color 0
    set flg_0 0
    set flg_1 0
    set flg_2 0

    for {set i 0} {$i < $len_lines} {incr i} {

      set line [string trim $lines_config_ini($i)]
      #puts $lines_config_ini($i)
      set status [regexp -- {^[\[]([^\[\]]+)[\]]} $line match s0]
      if { $status == 1 } {
        set flg_section_plugins_load_at_startup 0
        set flg_section_RemoteControl 0
        set flg_section_color 0
        if { $s0 eq "plugins_load_at_startup" } {
          set flg_section_plugins_load_at_startup 1
        } elseif { $s0 eq "RemoteControl" } {
          set flg_section_RemoteControl 1
        } elseif { $s0 eq "color" } {
          set flg_section_color 1
        }
      }

      if { $flg_section_plugins_load_at_startup != 0 } {
        set status [regexp -- {^([^= ]+)[ ]*[=][ ]*([^= ]+)} $line match s0 s1]
        if { $status == 1 && $s0 eq "RemoteControl" && $s1 eq "true" } {
          set flg_0 1
        }
      }
      if { $flg_section_RemoteControl != 0 } {
        set status [regexp -- {^([^= ]+)[ ]+[=][ ]+([^= ]+)} $line match s0 s1]
        if { $status == 1 && $s0 eq "autostart" && $s1 eq "true" } {
          set flg_1 1
        } elseif { $s0 eq "enable_cors" && $s1 eq "true" } {
          set flg_2 1
        }
      }

    }

    #

    if { $flg_0 == 0 || $flg_1 == 0 || $flg_2 == 0 } {
      #
      set lines_config_ini($len_lines) ""
      incr len_lines
      set lines_config_ini($len_lines) "\[plugins_load_at_startup\]"
      incr len_lines
      set lines_config_ini($len_lines) "RemoteControl = true"
      incr len_lines
      set lines_config_ini($len_lines) ""
      incr len_lines
      set lines_config_ini($len_lines) "\[RemoteControl\]"
      incr len_lines
      set lines_config_ini($len_lines) "autostart = true"
      incr len_lines
      set lines_config_ini($len_lines) "enable_cors = true"
      incr len_lines
      set lines_config_ini($len_lines) ""
      incr len_lines
      set lines_config_ini($len_lines) "\[color\]"
      incr len_lines
      set lines_config_ini($len_lines) "jupiter_orbit_color = 0.3,0.2,0.0"
      incr len_lines
      set lines_config_ini($len_lines) "mars_orbit_color    = 0.4,0.1,0.1"
      incr len_lines
      set lines_config_ini($len_lines) "mercury_orbit_color = 0.3,0.7,1.0"
      incr len_lines
      set lines_config_ini($len_lines) "moon_orbits_color   = 0.5,0.5,0.5"
      incr len_lines
      set lines_config_ini($len_lines) "neptune_orbit_color = 0.0,0.0,0.8"
      incr len_lines
      set lines_config_ini($len_lines) "saturn_orbit_color  = 0.3,0.3,0.2"
      incr len_lines
      set lines_config_ini($len_lines) "uranus_orbit_color  = 0.0,0.1,0.7"
      incr len_lines
      set lines_config_ini($len_lines) "venus_orbit_color   = 1.0,0.7,0.3"
      incr len_lines
      #

      if { [catch {open $fullpath_of_config_ini w} fid_w] } {
        puts stderr "ERROR: Cannot open(w) $fullpath_of_config_ini"
        exit -1
      } else {
        for {set i 0} {$i < $len_lines} {incr i} {
          puts $fid_w $lines_config_ini($i)
        }
        close $fid_w
      }

      puts "Info: updated $fullpath_of_config_ini"

    } else {

      puts "Info: $fullpath_of_config_ini is OK."

    }

  }

}

