############################################################################
##                                                                        ##
##  I N T E R S T E L L A R   C O N S O L E  Create filter for Milky Way  ##
##               Copyright (C) 2025- Misato Observatory, Wakayama, Japan  ##
##                                                                        ##
##  This software is available under the GPL (General Public License)     ##
##                                                                        ##
############################################################################

# This is required to dump canvas widget
package require Img

# size of image (size will be rescaled to 2x)
set width  1024
set height 512

#
# section-0
#

# filtering depth: max:1.0
set section0_depth 0.50

# start posision of filtering
set section0_x_begin 632

# width of first gradient
set section0_width_grad0 340
# width of constant area
set section0_width_const 20
# width of last gradient
set section0_width_grad1 140

#
# section-1
#

set section1_depth 0.32
set section1_x_begin 235
set section1_width_grad0 110
set section1_width_const 100
set section1_width_grad1 25


####  P R O C E D U R E S  ####

proc save_my_image {} {

  # dump .c0
  image create photo src -data .c0
  image create photo dest
  dest copy src -zoom 2
  dest write filter_data.png -format png

  # composite using "multiply" mode
  if { [catch {exec -ignorestderr magick composite -compose multiply milkyway.orig.png filter_data.png milkyway.png} result] } {
    tk_messageBox -type ok -icon info -title "ERROR" -message "Cannot exec magick!!"
  } else {
    tk_messageBox -type ok -icon info -title "OK" -message "Saved milkyway.png"
  }

  #set im [image create photo -data .c0]
  #$im write filter_data.png -format png

  #image create photo .photo
  #.photo configure -format window -data $c
  #.photo write filter_data.png -format gif

  exit

}


####  M A I N  ####

wm title . "ESC: exit  Enter: Save and Exit"

# EBhD̐ݒ
wm resizable . 0 0

#wm overrideredirect . 1
#wm attributes . -topmost yes
wm geometry . ${width}x${height}
#wm minsize . $width $height
#wm maxsize . $width $height
#wm attributes . -alpha "1"
#wm attributes . -transparentcolor black

option add *background "#ffffff"
option add *foreground "#000000"
option add *highlightThickness "0"
option add *borderWidth "0"

canvas .c0 -width $width -height $height
pack .c0

#bind  . <Key-space> "wm overrideredirect . 0"
#bind  . <Return> "wm overrideredirect . 1"
bind  . <Escape> "exit"
bind  . <KeyPress-q> "exit"
#bind  . <KeyPress-s> "save_my_image"
bind  . <Return> "save_my_image"

#

set x 0
set rgb "#ffffff"

#
# section-0
#

# start pos
set x0 $section0_x_begin
# width of first gradient
set i_len $section0_width_grad0
for {set i 0} {$i < $i_len} {incr i} {
  set x [expr ($x0 + $i) % $width]
  set id [.c0 create line $x 0 $x $height]
  set v [expr round(255.0 - 255.0 * $section0_depth * (1.0 * $i / $i_len))]
  set rgb [format "#%02x%02x%02x" $v $v $v]
  .c0 itemconfigure $id -fill $rgb
}

set x0 $x
# width of constant area
set i_len $section0_width_const
for {set i 0} {$i < $i_len} {incr i} {
  set x [expr ($x0 + $i) % $width]
  set id [.c0 create line $x 0 $x $height]
  .c0 itemconfigure $id -fill $rgb
}

set x0 $x
# width of last gradient
set i_len $section0_width_grad1
for {set i 0} {$i < $i_len} {incr i} {
  set x [expr ($x0 + $i) % $width]
  set id [.c0 create line $x 0 $x $height]
  set v [expr round(255.0 - 255.0 * $section0_depth * (1.0 * ($i_len - 1 - $i) / $i_len))]
  set rgb [format "#%02x%02x%02x" $v $v $v]
  .c0 itemconfigure $id -fill $rgb
}

#
# section-1
#

# start pos
set x0 $section1_x_begin
# width of first gradient
set i_len $section1_width_grad0
for {set i 0} {$i < $i_len} {incr i} {
  set x [expr ($x0 + $i) % $width]
  set id [.c0 create line $x 0 $x $height]
  set v [expr round(255.0 - 255.0 * $section1_depth * (1.0 * $i / $i_len))]
  set rgb [format "#%02x%02x%02x" $v $v $v]
  .c0 itemconfigure $id -fill $rgb
}

set x0 $x
# width of constant area
set i_len $section1_width_const
for {set i 0} {$i < $i_len} {incr i} {
  set x [expr ($x0 + $i) % $width]
  set id [.c0 create line $x 0 $x $height]
  .c0 itemconfigure $id -fill $rgb
}

set x0 $x
# width of last gradient
set i_len $section1_width_grad1
for {set i 0} {$i < $i_len} {incr i} {
  set x [expr ($x0 + $i) % $width]
  set id [.c0 create line $x 0 $x $height]
  set v [expr round(255.0 - 255.0 * $section1_depth * (1.0 * ($i_len - 1 - $i) / $i_len))]
  set rgb [format "#%02x%02x%02x" $v $v $v]
  .c0 itemconfigure $id -fill $rgb
}


update

