@echo off

call set_path.bat
set NIRCMD=.\nircmd.exe

REM Set (x,y) of Clock on your dome screen

set POS_X_FOR_SCREEN=+200
set POS_Y_FOR_SCREEN=+100

REM Configuration of Clock on your dome screen:
REM select orientation of clock (0:lower, 1:right, 2:upper, 3:left), and
REM set font size and parameters for placing chars.

set ORIENTATION=0
set FONT_SIZE=24
set RADIUS_FOR_PLACING_CHARS=1630
set ANGLE_BETWEEN_TWO_CHARS=1.2

REM For 2400x2400 projector of Misato Observatory (main)
REM set POS_X_FOR_SCREEN=+3695
REM set POS_Y_FOR_SCREEN=+2164
REM set RADIUS_FOR_PLACING_CHARS=1630

REM For 2400x2400 projector of Misato Observatory (backup)
REM set POS_X_FOR_SCREEN=+3042
REM set POS_Y_FOR_SCREEN=+2154
REM set RADIUS_FOR_PLACING_CHARS=1076


REM Batch begins ...

REM Note: Depending on the environment, specifying a "window title" as 
REM       an argument to nircmd, such as 
REM        nircmd.exe win close title "date-monitor", 
REM       may not work.  For this reason, we use the handle ID obtained 
REM       with PowerShell for nircmd args.

REM 
REM STEP-1
REM 

REM get handle ID of "date-monitor" window
call :ps1_get_handle

if "%1" == "" (

  REM start date-monitor for FullHD Display

  start /WAIT %NIRCMD% win close handle %HANDLEID%

  start /WAIT %NIRCMD% wait 200

  start wish.exe date-monitor.tcl

  start /WAIT %NIRCMD% wait 500

) else if "%1" == "screen" (

  REM start date-monitor for Screen

  start /WAIT %NIRCMD% win close handle %HANDLEID%

  start /WAIT %NIRCMD% wait 200

  start wish.exe date-monitor.tcl %ORIENTATION% %FONT_SIZE% %RADIUS_FOR_PLACING_CHARS% %ANGLE_BETWEEN_TWO_CHARS%

  start /WAIT %NIRCMD% wait 500

) else if "%1" == "kill" (

  REM start /WAIT %NIRCMD% win close title "date-monitor"
  start /WAIT %NIRCMD% win close handle %HANDLEID%

  goto :quit

) else if "%1" == "change" (

  start /WAIT %NIRCMD% win activate handle %HANDLEID%
  start /WAIT %NIRCMD% wait 200
  start /WAIT %NIRCMD% sendkey tab press

  goto :quit

) else (

  goto :quit

)


REM 
REM STEP-2
REM 

REM get handle ID of "date-monitor" window
call :ps1_get_handle

if "%1" == "" (

  start /WAIT %NIRCMD% win settopmost handle %HANDLEID% 1
  start /WAIT %NIRCMD% wait 500
  start /WAIT %NIRCMD% win settopmost handle %HANDLEID% 1

) else if "%1" == "screen" (

  start /WAIT %NIRCMD% win settopmost handle %HANDLEID% 1
  start /WAIT %NIRCMD% wait 500
  start /WAIT %NIRCMD% win settopmost handle %HANDLEID% 1

  start /WAIT %NIRCMD% wait 500
  REM start /WAIT %NIRCMD% win move title "date-monitor" %POS_X_FOR_SCREEN% %POS_Y_FOR_SCREEN%
  start /WAIT %NIRCMD% win move handle %HANDLEID% %POS_X_FOR_SCREEN% %POS_Y_FOR_SCREEN%

  start /WAIT %NIRCMD% win activate handle %HANDLEID%
  REM start /WAIT %NIRCMD% wait 200
  REM start /WAIT %NIRCMD% sendkey tab press

)

:quit

exit


REM ################################################################
REM Get the handle ID of "date-monitor" window

:ps1_get_handle

for /f "usebackq delims=" %%A in (`powershell.exe -NoLogo -ExecutionPolicy Bypass -File .\get_date-monitor_handle.ps1`) do set HANDLEID=%%A
if "%HANDLEID%" == "" (
  set HANDLEID=-
)

exit /b

