//
// Name: INTERSTELLAR CONSOLE -- Zoom to DSO
// Author: Misato Observatory, Wakayama, Japan
// License: GPL (General Public License)
//

include("./getFlagDomeMode.inc");

function moveZoomToSelected( fov )
{

  core.setTimeRate(0.0);

  if ( getFlagDomeMode() == true ) {
    if ( LandscapeMgr.getFlagLandscape() == true ) {
      LandscapeMgr.setFlagLandscape(false);
      core.wait(1.0);
    }
    core.setSelectedObjectMarkerVisible(false);
  }

  if ( 179 < StelMovementMgr.getCurrentFov() ) {
    core.moveToSelectedObject(0.5);
    StelMovementMgr.zoomTo(fov,4.0);
  } else {
    core.moveToSelectedObject(0.0);
    StelMovementMgr.zoomTo(fov,0.5);
  }

  return 0;

}

