@echo off

REM ExecutionPolicy of powershell.exe
set EXPOLICY=Bypass

echo //
echo // INTERSTELLAR CONSOLE startup script

REM Parsing arguments

set GUI_ONLY=0
set MODE=-
for %%f in (%*) do (
  if "%%f" == "-gui-only" (
    set GUI_ONLY=1
  ) else if "%%f" == "-navi" (
    set MODE=navigation
  ) else if "%%f" == "-dome" (
    set MODE=dome
  ) else if "%%f" == "-kill" (
    set MODE=kill
  )
)

echo // Mode: %MODE%
echo //

call set_path.bat

REM Cleanup...

taskkill /F /im wish.exe >nul 2>&1

if "%GUI_ONLY%" == "1" (
  REM GUI only
  if "%MODE%" == "kill" (
    exit
  )
  call :ps1_sleep 1
  goto :next1
)

taskkill /F /im stellarium.exe >nul 2>&1
taskkill /F /im tclsh.exe >nul 2>&1
call :ps1_sleep 1

if "%MODE%" == "kill" (
  exit
)


echo Confirm Tcl/Tk ...

where /Q tclsh
if errorlevel 1 (
  echo ERROR: Tcl/Tk is not installed!
  call :ps1_exec_file .\no_tcl_msg.ps1
  call :ps1_sleep 2
  exit 1
)
where /Q wish
if errorlevel 1 (
  echo ERROR: Tcl/Tk is not installed!
  call :ps1_exec_file .\no_tcl_msg.ps1
  call :ps1_sleep 2
  exit 1
)

echo Prepare config.ini ...

if exist "%HOMEDRIVE%%HOMEPATH%\AppData\Roaming\Stellarium\config.ini" (
  goto :prepare_next
)

start "" "C:\Program Files\Stellarium\stellarium.exe" --full-screen no

:loop_prepare

  if exist "%HOMEDRIVE%%HOMEPATH%\AppData\Roaming\Stellarium\config.ini" (
    call :ps1_sleep 5
    taskkill /F /im stellarium.exe >nul 2>&1
    goto :prepare_next
  )

  call :ps1_sleep 1

goto :loop_prepare

:prepare_next

tclsh.exe isc-prepare.tcl "%HOMEDRIVE%%HOMEPATH%\AppData\Roaming\Stellarium\config.ini"


echo Exec ISC Info Server ...
start /min cmd.exe /c tclsh.exe iscserv.tcl "%HOMEDRIVE%%HOMEPATH%\AppData\Roaming\Stellarium" 8091

:loop0

  REM Check that ISC Info Server has finished booting
  curl -s -G http://localhost:8091/

  if not errorlevel 1 (
    goto :next0
  )

  call :ps1_sleep 1

goto :loop0

:next0

REM start /WAIT .\nircmd.exe win min ititle "tclsh.exe"


echo Exec Stellarium ...

if "%MODE%" == "dome" (
  start "" "C:\Program Files\Stellarium\stellarium.exe" --full-screen yes
) else (
  start "" "C:\Program Files\Stellarium\stellarium.exe" --full-screen no
)

echo Waiting for Stellarium to finish booting ...

:loop1

  REM Check that Stellarium has finished booting
  curl -s -G http://localhost:8090/api/main/status

  if not errorlevel 1 (
    goto :next1
  )

  call :ps1_sleep 1

goto :loop1

:next1

echo Exec GUI

if "%GUI_ONLY%" == "1" (
  REM Check that Stellarium has finished booting
  curl -s -G http://localhost:8090/api/main/status
  if errorlevel 1 (
    echo ERROR: No response from Stellarium!
    call :ps1_exec_file .\no_stl_response_msg.ps1
    call :ps1_sleep 2
    exit 1
  )
  set INIT_ARG=-
) else (
  set INIT_ARG=-init
)

if "%MODE%" == "navigation" (
  start wish.exe misato-gui.tcl -navi %INIT_ARG%
) else if "%MODE%" == "dome" (
  start wish.exe misato-gui.tcl -dome %INIT_ARG%
) else (
  start wish.exe misato-gui.tcl %INIT_ARG%
)

REM Apply this batch when booting without full-screen mode.
REM (This uses another process to avoid blocking signals)
REM start cmd.exe /c make_stellarium_fullscreen.bat

exit



REM ################################################################

:ps1_exec_file

powershell.exe -NoLogo -ExecutionPolicy %EXPOLICY% -File %1

exit /b

REM ################################################################
REM The timeout command seems unstable.
REM Use the powershell sleep command instead.

:ps1_sleep

powershell.exe -NoLogo -ExecutionPolicy %EXPOLICY% sleep %1

exit /b

