#########################################################################
##                                                                     ##
##  I N T E R S T E L L A R   C O N S O L E                            ##
##            Copyright (C) 2025- Misato Observatory, Wakayama, Japan  ##
##                                                                     ##
##  This software is available under the GPL (General Public License)  ##
##                                                                     ##
#########################################################################

# Get OS name

if { [info exists ::env(OS)] != 0 } {
  set os_name $::env(OS)
}
if { $os_name eq "" } {
  set os_name [exec -ignorestderr uname]
}
if { $os_name eq "" } {
  set os_name "Unknown OS"
}

# Set App Launcher

if { $os_name eq "Darwin" } {
  # MacOS
  set app_launcher "open -a"
} else {
  # Windows
  set app_launcher ""
}

####################################################################
##                                                                ##
##                     L O C A L  C O N F I G                     ##
##                                                                ##
####################################################################

# URL of Stellarium Service
#
set stellarium_url "http://localhost:8090"
set iscserv_url    "http://localhost:8091"

# Text Editor
#
if { $os_name eq "Darwin" } {
  # MacOS
  set text_editor "TextEdit"
} else {
  # Windows
  set text_editor "notepad.exe"
}

