#########################################################################
##                                                                     ##
##  I N T E R S T E L L A R   C O N S O L E  Media GUI                 ##
##            Copyright (C) 2025- Misato Observatory, Wakayama, Japan  ##
##                                                                     ##
##  This software is available under the GPL (General Public License)  ##
##                                                                     ##
##       Tcl/Tk References: http://www.nct9.ne.jp/m_hiroi/tcl_tk_doc/  ##
##                                                                     ##
#########################################################################


####################################################################
##                                                                ##
##                   L O C A L  S E T T I N G S                   ##
##                                                                ##
####################################################################

#
# Mode
#
set flag_dome_mode 0
for {set i 0} {$i < $argc} {incr i} {
  if { [lindex $argv $i] eq "-dome" } {
    set flag_dome_mode 1
  }
}

#
# T[oURL, fBNg
#
source local-config.tcl

#
# 摜E悪i[ftHg̃fBNg
#
set config_default_media_dir "media"

#
#  tHg̐ݒ
#
if { $flag_dome_mode == 0 } {
  # Navigation Mode
  # ftHg
  option add *font {"MS Gothic" 12}
  set font_small {"MS Gothic" 10}
  # xt[
  set font_labelframe {"MS Gothic" 10}
  # 
  set font_internal {"MS Gothic" 10}
} else {
  # Dome Mode
  # ftHg
  option add *font {"MS Gothic" 20}
  set font_small {"MS Gothic" 16}
  # xt[
  set font_labelframe {"MS Gothic" 12}
  # 
  set font_internal {"MS Gothic" 10}
}

#
# eEBWFbg̃J[ݒ
#
option add *background "#000000"
option add *foreground "#ff5050"
option add *activeBackground "#c08000"
option add *Button.background "#383838"
option add *Button.foreground "#ff6060"
option add *Button.padX "1"
option add *Button.padY "1"
option add *Entry.background "#303030"
option add *Entry.foreground "#ffe000"
option add *Entry.insertForeground "#000000"
option add *Entry.insertBackground "#00ff00"
option add *Entry.disabledBackground "#000000"
option add *Entry.disabledForeground "#ff6060"

#
# Do not change: Set stellarium_script_dir from localConfig.ssc
#
if { [catch {open "localConfig.ssc" r} fid] } {
  tk_messageBox -type ok -icon info -title "ERROR" -message "Cannot open localConfig.ssc."
  exit
} else {
  set stellarium_script_dir "interstellar-console"
  while { [gets $fid line] >= 0 } {
    set status [regexp -- {^[ ]*var[ ]+([A-Za-z0-9_]+)[ ]*[=][ ]*["]([^"]+)["]} $line match s0 s1]
    if { $status == 1 && $s0 eq "stellarium_script_dir" } {
      set stellarium_script_dir $s1
    }
  }
  close $fid
}

#
# T[oURL (1)  T[oɕۑĂXNvg(staticȃR[h)
#                s鎞ɗp
# 
set stellarium_run_url "$stellarium_url/api/scripts/run"

#
# T[oURL (2)  NCAgŐXNvg(dynamicȃR[h)
#                𑗐M鎞ɗp
# 
#   ӁFdirect gꍇAsł̂͂Pŝ݂炵B
#         s̃R[h𑗐MƁAStellariumNbV
set stellarium_direct_url "$stellarium_url/api/scripts/direct"

#
# T[oURL (3)  擾p
# 
set stellarium_status_url "$stellarium_url/api/main/status"


####################################################################
##                                                                ##
##                       P R O C E D U R E S                      ##
##                                                                ##
####################################################################

#
# ėpFstellarium XNvgns 𑗐M (ψ)
#
#  yӁz
#    Eargs[n] ɋ󔒂ꂽꍇ [~] A["] ꂽꍇ ['] ƂB
#      F "Ursa Major"  'Ursa~Major' Ƃ
#    EMł̂́A֐̗񂾂łB
#      StellariumNbV邽߁Afor()Ȃǂ̐\𑗂Ă͂ȂȂB
#
proc send_ssc_lines { args } {

  global stellarium_direct_url
  global buffer_internal_info
  # Set debug=1 to write code to $code_file
  set debug 0
  set code_file "tmp.txt"

  foreach code1line $args {

    # replace [~] with [ ], and ['] with ["]
    set code_p0 [regsub -all {~} $code1line { }]
    set code_p1 [regsub -all {'} $code_p0 {"}]
    set buffer_codefield "$code_p1"

    set buffer_internal_info $buffer_codefield

    if { $debug == 0 } {
      set f [open "| curl -s -d @- $stellarium_direct_url" w]
        puts -nonewline $f "code="
        puts -nonewline $f "$buffer_codefield"
        puts $f ";"
      catch {close $f} std_err
    } else {
      set f [open $code_file w]
        puts -nonewline $f "code="
        puts -nonewline $f "$buffer_codefield"
        puts $f ";"
      catch {close $f} std_err
      set ret [exec -ignorestderr curl -s -d @$code_file $stellarium_direct_url]
    }

  }

}

#
# ėpFfilename_text ǂݍ݁A1s=1vf̔z array_ret ɕԂ
#
proc get_array_from_text_lines { filename_text array_ret } {

  upvar $array_ret array_ref

  array set array_ref {}

  if { [catch {open $filename_text r} fid] } {
    # do nothing
  } else {
    set i 0
    while { [gets $fid line] >= 0 } {
      set s [string trim $line]
      # skip comments
      if { [string length $s] != 0 && [string index $s 0] ne "#" } {
        set array_ref($i) $s
        incr i
      }
    }
    close $fid
  }

}

#                                        #
# proc͓̃EBWFbgp #
#                                        #

# load and display a sky image
proc display_sky_image { image_id } {

  global flag_sky_image
  global name_sky_image
  global param_sky_image
  global checkbox_sky_image

  if { $checkbox_sky_image($image_id) != 0 } {
    send_ssc_lines "core.loadSkyImage($name_sky_image($image_id),$param_sky_image($image_id))"
  } else {
    send_ssc_lines "core.removeSkyImage($name_sky_image($image_id))"
  }

}

# remove all sky images
proc remove_all_sky_images {} {

  global name_sky_image
  global checkbox_sky_image

  set len_names [array size name_sky_image]

  for {set i 0} {$i < $len_names} {incr i} {
    send_ssc_lines "core.removeSkyImage($name_sky_image($i))"
    set checkbox_sky_image($i) 0
  }

}

# build GUI of image list
proc build_sky_image_check_list { filename_text } {

  global font_small
  global stellarium_script_dir
  global config_default_media_dir

  global flag_sky_image
  global name_sky_image
  global param_sky_image

  array set flag_sky_image {}
  array set name_sky_image {}
  array set param_sky_image {}

  array set lines {}

  get_array_from_text_lines $filename_text lines

  set len_lines [array size lines]

  for {set i 0} {$i < $len_lines} {incr i} {
    set lst [split $lines($i) ","]
    if { 6 <= [llength $lst] } {
      set s0 [string trim [lindex $lst 0]]
      set s1 [string trim [lindex $lst 1]]
      if { [string match {[A-Za-z]:[/\\]*} $s1] } {
        set path_s1 [regsub -all {[\\]} $s1 "/"]
      } elseif { [string match {[/\\]*} $s1] }  {
        set path_s1 [regsub -all {[\\]} $s1 "/"]
      } else {
        set path_s1 "$stellarium_script_dir/$config_default_media_dir/$s1"
      }
      set s2 [string trim [lindex $lst 2]]
      set s3 [string trim [lindex $lst 3]]
      set s4 [string trim [lindex $lst 4]]
      set s5 [string trim [lindex $lst 5]]
      set s6 [string trim [lindex $lst 6]]
      if { $s6 eq "" } {
        set s6 "0"
      }
      set s7 [string trim [lindex $lst 7]]
      if { $s7 eq "" } {
        set s7 "2.5"
      }
      set s8 [string trim [lindex $lst 8]]
      if { $s8 eq "" } {
        set s8 "-14"
      }
      set flag_sky_image($i) 0
      set name_sky_image($i) "'$s0'"
      set param_sky_image($i) "'$path_s1',$s3,$s4,$s5,$s6,$s7,$s8,true,'$s2'"
      frame .fr_cb_sky_image_$i
      checkbutton .cb_sky_image_$i -text "$s0" -font $font_small -variable checkbox_sky_image($i) -command "display_sky_image $i"
      label .cl_sky_image_$i -text "($s1, $s2, $s3, $s4, $s5)" -font $font_small
      pack .cb_sky_image_$i -side left -expand 0 -fill x -in .fr_cb_sky_image_$i
      pack .cl_sky_image_$i -expand 1 -fill x -in .fr_cb_sky_image_$i
      pack .fr_cb_sky_image_$i -expand 0 -fill x -in .lf_sky_image
    }
  }
}

####################################################################
##                                                                ##
##                             M A I N                            ##
##                                                                ##
####################################################################

# EBhD,̐ݒ
wm title . "Intersteller Console :: media"
wm resizable . 0 0

# EBWFbg̐ݒ
option add *Labelframe.padX "2"
option add *Labelframe.padY "2"
option add *Entry.justify "center"

set buffer_internal_info "-"

array set checkbox_sky_image {}
array set flag_sky_image {}
array set name_sky_image {}
array set param_sky_image {}


########################################################################

frame .fr_rootwin

########################################################################

labelframe .lf_sky_image -text "Sky Image" -font $font_labelframe

frame .fr_label_sky_image

label .l_sky_image -text "摜I"
button .b_sky_image_aoff -text "SOff" -font $font_small -command "remove_all_sky_images"
button .b_sky_image_edit -text "ҏW" -font $font_small -command "exec $text_editor $config_default_media_dir/list_sky-image.txt &"
pack .l_sky_image -side left -expand 1 -fill x -in .fr_label_sky_image
pack .b_sky_image_aoff .b_sky_image_edit -side left -expand 0 -fill x -in .fr_label_sky_image
pack .fr_label_sky_image -expand 0 -fill x -in .lf_sky_image

build_sky_image_check_list $config_default_media_dir/list_sky-image.txt

pack .lf_sky_image -expand 0 -fill both -padx 4 -pady 3 -in .fr_rootwin

################################################################

labelframe .lf_internal -text "Internal Info" -font $font_labelframe

entry .e_debug -textvariable buffer_internal_info -font $font_internal -justify left
pack .e_debug -expand 1 -fill both -in .lf_internal

pack .lf_internal -expand 0 -fill x -padx 4 -pady 3 -in .fr_rootwin

########################################################################

pack .fr_rootwin

