@echo off

echo //
echo // INTERSTELLAR CONSOLE CXg[
echo // Copyright (C) 2025- Misato Observatory, Wakayama, Japan
echo //

REM ExecutionPolicy of powershell.exe
set EXPOLICY=Bypass

REM concatenate directory name with spc
if "%1" == "" (
  echo ERROR: empty arg
  call :ps1_sleep 2
  exit 1
) else if "%2" == "" (
  set PD=%1
) else (
  set PD=%1 %2
)

echo PACKAGE:
cd /D "%PD%"
if errorlevel 1 (
  echo ERROR: Network drive is not supported
  call :ps1_exec_file .\setup\unc_err_msg.ps1
  exit 1
)
cd
call :ps1_sleep 3
REM pause

set STELDIR=C:\Program Files\Stellarium
if not exist "%STELDIR%" (
  call :ps1_exec_file .\setup\not_installed_msg.ps1
  exit 1
)

set TEXTURESDIR=%STELDIR%\textures
if not exist "%TEXTURESDIR%" (
  call :ps1_exec_file .\setup\not_installed_msg.ps1
  exit 1
)

set SKYCULDIR=%STELDIR%\skycultures
if not exist "%SKYCULDIR%" (
  call :ps1_exec_file .\setup\not_installed_msg.ps1
  exit 1
)

set QMSKYCULDIR=%STELDIR%\translations\stellarium-skycultures
if not exist "%QMSKYCULDIR%" (
  call :ps1_exec_file .\setup\not_installed_msg.ps1
  exit 1
)

set SSCDIR=%STELDIR%\scripts
if not exist "%SSCDIR%" (
  call :ps1_exec_file .\setup\not_installed_msg.ps1
  exit 1
)

set DESTDIR=%SSCDIR%\interstellar-console

echo DESTDIR:
echo %DESTDIR%

if "%PD%" == "%DESTDIR%" (
  echo ERROR: SRC directory is DEST directory!
  call :ps1_exec_file .\setup\unknown_err_msg.ps1
  exit 1
)

if exist "%DESTDIR%" (
  dir "%DESTDIR%\." >nul 2>&1
  if errorlevel 1 (
    echo ERROR: %DESTDIR% already exists, but it is a file!
    call :ps1_exec_file .\setup\unknown_err_msg.ps1
    exit 1
  ) else (
    echo OK: %DESTDIR%
  )
) else (
  mkdir "%DESTDIR%"
  if exist "%DESTDIR%" (
    echo OK: %DESTDIR%
  ) else (
    echo ERROR: cannot create %DESTDIR%
    call :ps1_exec_file .\setup\unknown_err_msg.ps1
    exit 1
  )
)


echo 1ݒ蒆...

cacls "%DESTDIR%" /E /G Users:F
call :ps1_sleep 3

echo 2ݒ蒆...

cacls "%TEXTURESDIR%" /E /G Users:F
call :ps1_sleep 3


echo \tgEFA{̂Rs[...

xcopy ".\isc_*.exe" "%DESTDIR%\." /F /Y /R
xcopy ".\nircmd-x64\nircmd.exe" "%DESTDIR%\." /F /Y /R
xcopy ".\nkfwin\nkf.exe" "%DESTDIR%\." /F /Y /R
xcopy ".\*.bat" "%DESTDIR%\." /F /Y /R
xcopy ".\*.ps1" "%DESTDIR%\." /F /Y /R
xcopy ".\*.tcl" "%DESTDIR%\." /F /Y /R
xcopy ".\splash.gif" "%DESTDIR%\." /F /Y /R
xcopy ".\*.inc" "%DESTDIR%\." /F /Y /R
xcopy ".\*.ssc" "%DESTDIR%\." /F /Y /R
xcopy ".\*.txt" "%DESTDIR%\." /F /Y /R
xcopy ".\images\*" "%DESTDIR%\images\." /F /Y /R /I /E
xcopy ".\media\*" "%DESTDIR%\media\." /F /Y /R /I /E
xcopy ".\milkyway\*" "%DESTDIR%\milkyway\." /F /Y /R /I /E
xcopy ".\japanese_default-art\*" "%SKYCULDIR%\japanese\." /F /Y /R /I /E
xcopy ".\japanese_default-art\*" "%SKYCULDIR%\japanese_default-art\." /F /Y /R /I /E
if exist "%QMSKYCULDIR%\ja.qm" (
  if not exist "%QMSKYCULDIR%\ja.qm.old" (
    copy "%QMSKYCULDIR%\ja.qm" "%QMSKYCULDIR%\ja.qm.old" /B /Y
  )
)
xcopy ".\translations\ja.qm" "%QMSKYCULDIR%\." /F /Y /R

powershell.exe -NoLogo -ExecutionPolicy %EXPOLICY% -File .\setup\copy_milkyway.ps1 "%DESTDIR%\milkyway\milkyway.png" "%TEXTURESDIR%\."


echo GRs[...

xcopy "..\art\*.png" "%SKYCULDIR%\japanese\." /F /Y /R
xcopy "..\art\*.ini" "%SKYCULDIR%\japanese\." /F /Y /R
xcopy "..\art\description.*" "%SKYCULDIR%\japanese\." /F /Y /R


echo Tcl/Tk-9p\[Xt@C쐬...

if not exist "%DESTDIR%\tcl_utf8" (
  mkdir "%DESTDIR%\tcl_utf8"
)
.\nkfwin\nkf.exe -S -w .\misato-gui.tcl > "%DESTDIR%\tcl_utf8\misato-gui.tcl"
.\nkfwin\nkf.exe -S -w .\date-gui.tcl > "%DESTDIR%\tcl_utf8\date-gui.tcl"
.\nkfwin\nkf.exe -S -w .\date-monitor.tcl > "%DESTDIR%\tcl_utf8\date-monitor.tcl"


echo fXNgbvɃV[gJbg쐬...

set EXENAME=isc_navigator
echo 쐬 : %EXENAME%
powershell.exe -NoLogo -ExecutionPolicy %EXPOLICY% -File .\setup\mk_shortcut_on_desktop.ps1 "%DESTDIR%\%EXENAME%.exe" "%EXENAME%.lnk" "%DESTDIR%"

set EXENAME=isc_dome
echo 쐬 : %EXENAME%
powershell.exe -NoLogo -ExecutionPolicy %EXPOLICY% -File .\setup\mk_shortcut_on_desktop.ps1 "%DESTDIR%\%EXENAME%.exe" "%EXENAME%.lnk" "%DESTDIR%"

set EXENAME=isc_gui
echo 쐬 : %EXENAME%
powershell.exe -NoLogo -ExecutionPolicy %EXPOLICY% -File .\setup\mk_shortcut_on_desktop.ps1 "%DESTDIR%\%EXENAME%.exe" "%EXENAME%.lnk" "%DESTDIR%"


echo ZbgAbv܂I

call :ps1_exec_file .\setup\last_msg.ps1

exit



REM ################################################################

:ps1_exec_file

powershell.exe -NoLogo -ExecutionPolicy %EXPOLICY% -File %1

exit /b

REM ################################################################
REM The timeout command seems unstable.
REM Use the powershell sleep command instead.

:ps1_sleep

powershell.exe -NoLogo -ExecutionPolicy %EXPOLICY% sleep %1

exit /b

