
# Check Windows Version

$winVersion = 0
$winVersion = [System.Environment]::OSVersion.Version.Major

if ( $winVersion -eq 0 ) {
  Write-Host "ERROR: Unexpected error."
  Start-Sleep -Seconds 5
  exit 1
}

Write-Host "`r`nMajor Version of this Windows is $winVersion`r`n"

if ( $winVersion -lt 10 ) {
  Write-Host "ERROR: Too OLD windows!! NOT supported."
  Start-Sleep -Seconds 5
  exit 1
}

# Start...

Set-StrictMode -version Latest

Add-Type -AssemblyName System.Windows.Forms;

$text = "Interstellar Consoleł́AStellariumɂ`r`n 1. o[Ẃy24.4-qt5z`r`n 2. ZbgAbvŁyFor all userszI`r`n 3. CXg[̓ftHg`r`nOƂĂ܂B`r`n̏𖞂Ȃꍇ͓삵܂̂łӂBInterstellar Console ̃ZbgAbvJn܂H";
$caption = "Setup: Interstellar Console";
$buttonsType = "YesNo";
$iconType = "Information";

$result = [System.Windows.Forms.MessageBox]::Show($text, $caption, $buttonsType, $iconType);

if ( $result -eq "No" ) {
  exit
}

#Write-Host "$PSCommandPath"

$currentDirectory = Get-Location
#Write-Host "$currentDirectory"

# Using "-Verb runAs" to launch processes with elevated privileges via UAC (User Access Control)
Start-Process -FilePath .\interstellar-console\setup\do.bat -ArgumentList "$currentDirectory\interstellar-console" -Verb runAs

