#########################################################################
##                                                                     ##
##  I N T E R S T E L L A R   C O N S O L E  Displaying Date Time      ##
##            Copyright (C) 2025- Misato Observatory, Wakayama, Japan  ##
##                                                                     ##
##  This software is available under the GPL (General Public License)  ##
##                                                                     ##
##  arg is set : for dome screen                                       ##
##  no arg     : for Full-HD display                                   ##
##                                                                     ##
##  Esc key    : exit                                                  ##
##  Space key  : set overrideredirect                                  ##
##  Enter key  : unset overrideredirect                                ##
##  Tab key    : center mark on/off (dome screen only)                 ##
##                                                                     ##
#########################################################################


####################################################################
##                                                                ##
##                   L O C A L  S E T T I N G S                   ##
##                                                                ##
####################################################################

#
# T[oURL, fBNg
#
source local-config.tcl

#
#  tHg,EBhDTCY̐ݒ (Display[h)
#
set date_font_for_virt {"Trebuchet MS" 255}
set time_font_for_virt {"Trebuchet MS" 330}
set width_virt 1920
set height_virt 1080

#
#  tHg,EBhDTCY̐ݒ l (Screen[h)
#
set orientation 0
set font_datetime {"Vardana" 26 "bold"}
set font_size [lindex $font_datetime 1]

set radius_for_placing_chars 1677
set angle_between_two_chars 1.2

##set pixels_dome_screen [expr 1.5 * 2400 * (177.0 / 190.0)]
##set width_datetime [expr 6 + 32 * 38]
##set height_datetime [expr 4 + 22 * 8]

#
# eEBWFbg̃J[ݒ
#
option add *background "#000000"
option add *foreground "#d03030"
# XN[Ŏgp
set text_foreground "#ff5010"

option add *highlightThickness "0"

#
# T[oURL (1)  擾p
# 
set stellarium_status_url "$stellarium_url/api/main/status"


####################################################################
##                                                                ##
##                       P R O C E D U R E S                      ##
##                                                                ##
####################################################################

#
# t/XN[\p
#
proc draw_on_screen { date_string time_string } {

  global orientation
  global radius_for_placing_chars
  global angle_between_two_chars
  global width_datetime
  global height_datetime
  global horizontal_center
  global vertical_offset
  global text_foreground
  global font_datetime
  global layer_id
  global flag_center_mark

  set r [expr $radius_for_placing_chars * 1.0]

  set m_pai [expr acos(-1.0)]

  set font_test {"Vardana" 80}
  set x_center [expr $width_datetime * 0.5]
  set y_center [expr $height_datetime * 0.5]

  .c$layer_id delete all

  if { $flag_center_mark == 1 } {
    if { $layer_id == 0 } {
      .c0 create line $x_center 0 $x_center $height_datetime -fill $text_foreground
      .c0 create line 0 $y_center $width_datetime $y_center -fill $text_foreground
      .c0 create text $x_center $y_center -fill $text_foreground -font $font_test -text "I" -anchor center -justify center -angle 45
      .c0 create text $x_center $y_center -fill $text_foreground -font $font_test -text "I" -anchor center -justify center -angle 135
    } else {
      .c1 create line $x_center 0 $x_center $height_datetime -fill $text_foreground
      .c1 create line 0 $y_center $width_datetime $y_center -fill $text_foreground
      .c1 create text $x_center $y_center -fill $text_foreground -font $font_test -text "I" -anchor center -justify center -angle 0
      .c1 create text $x_center $y_center -fill $text_foreground -font $font_test -text "I" -anchor center -justify center -angle 90
    }
  }

  #
  if { $orientation == 3 } {
    set flg_sw0 0
    set flg_sw1 1
    set chr_sign 1.0
    set drw_sign -1.0
    set chr_rot 270.0
  } elseif { $orientation == 2 } {
    set flg_sw0 1
    set flg_sw1 0
    set chr_sign -1.0
    set drw_sign -1.0
    set chr_rot 180.0
  } elseif { $orientation == 1 } {
    set flg_sw0 0
    set flg_sw1 1
    set chr_sign -1.0
    set drw_sign 1.0
    set chr_rot 90.0
  } else {
    set flg_sw0 1
    set flg_sw1 0
    set chr_sign 1.0
    set drw_sign 1.0
    set chr_rot 0.0
  }

  #
  set len_date_string [string length $date_string]
  for {set idx 0} {$idx < $len_date_string} {incr idx} {

    set ch [string index $date_string $idx]
    set i [expr $chr_sign * (-4 - $len_date_string + $idx)]
    set theta [expr $i * $angle_between_two_chars]
    set rad_theta [expr $m_pai * $theta / 180.0]
    set chr_theta [expr ($chr_sign * $theta) + $chr_rot]
    set x0 [expr $horizontal_center + ($r * sin($rad_theta))]
    set y0 [expr $drw_sign * (($r * cos($rad_theta)) - $r) + $vertical_offset]
    set x [expr $x0 * $flg_sw0 + $y0 * $flg_sw1]
    set y [expr $y0 * $flg_sw0 + $x0 * $flg_sw1]
    #
    .c$layer_id create text $x $y -fill $text_foreground -font $font_datetime -anchor center -justify center -text $ch -angle $chr_theta

  }

  #                  1 2 : 3 5 : 5 9
  set lst_time [list 0 1 2 3 4 5 6 7]
  foreach idx $lst_time {

    set ch [string index $time_string $idx]
    set i [expr $chr_sign * (5 + $idx)]
    set theta [expr $i * $angle_between_two_chars]
    set rad_theta [expr $m_pai * $theta / 180.0]
    set chr_theta [expr ($chr_sign * $theta) + $chr_rot]
    set x0 [expr $horizontal_center + ($r * sin($rad_theta))]
    set y0 [expr $drw_sign * (($r * cos($rad_theta)) - $r) + $vertical_offset]
    set x [expr $x0 * $flg_sw0 + $y0 * $flg_sw1]
    set y [expr $y0 * $flg_sw0 + $x0 * $flg_sw1]
    #
    .c$layer_id create text $x $y -fill $text_foreground -font $font_datetime -anchor center -justify center -text $ch -angle $chr_theta

  }

  if { $layer_id == 0 } {
    .pw forget .c1
    .pw add .c0
    set layer_id 1
  } else {
    .pw forget .c0
    .pw add .c1
    set layer_id 0
  }

}

#
# t/\p [v
#
proc show_time { prev_sec } {

  global display_style
  global stellarium_status_url
  global buffer_date_label
  global buffer_time_label

  #set f [open "| curl -s -G $stellarium_status_url" r]
  #set line [read -nonewline $f]
  ## avoid Tcl/Tk Error
  #catch {close $f} std_err

  if { [catch {set line [exec -ignorestderr curl -s -G $stellarium_status_url]} result] } {
    exit
  }

  set status [regexp -- {.*["]local["]:["]([^"T]+)T([^".]+)} $line match date_string time_string]
  if { $status == 1 } {
    set buffer_date_label $date_string
    set buffer_time_label $time_string
    if { $display_style != 0 } {
      draw_on_screen [format "%11s" $date_string] $time_string
    }
  }

  set ch_s3 [string index $time_string 3]
  set ch_s2 [string index $time_string 4]
  set ch_s1 [string index $time_string 6]
  set ch_s0 [string index $time_string 7]
  set sec [expr 600 * $ch_s3 + 60 * $ch_s2 + 10 * $ch_s1 + $ch_s0]
  # σEGCg
  if { 1.0 < abs($sec - $prev_sec) } {
    set wait_msec 100
  } else {
    set wait_msec 500
  }

  after $wait_msec show_time $sec

}

#
# Z^[}[N\ ؑ (TABL[ŌĂяo)
#
proc toggle_center_mark {} {
  global flag_center_mark
  if { $flag_center_mark == 0 } {
    set flag_center_mark 1
  } else {
    set flag_center_mark 0
  }
}


####################################################################
##                                                                ##
##                             M A I N                            ##
##                                                                ##
####################################################################

# hide default wish window
wm state . withdrawn

# EBhD̐ݒ
wm resizable . 0 0

#  flag (\g)
set flag_center_mark 0

# l
set buffer_date_label "+0000-00-00"
set buffer_time_label "12:00:00"

#  ؂ւXCb`
#
#  0: Display[h ... tE㉺ɕׂ (^j^[p)
#  1: Screen[h  ... tE~ʏɕ\ (SVXN[p)
#
set display_style 0

if { 0 < $argc } {

  set display_style 1

  # Screen[hł̃p[^ݒ

  if { 0 < $argc } {
    set orientation [lindex $argv 0]
  }

  if { 1 < $argc } {
    set font_size [lindex $argv 1]
    lset font_datetime 1 $font_size
  }

  if { 2 < $argc } {
    set radius_for_placing_chars [lindex $argv 2]
  }

  if { 3 < $argc } {
    set angle_between_two_chars [lindex $argv 3]
  }

  set m_pai [expr acos(-1.0)]
  set r [expr $radius_for_placing_chars * 1.0]
  set theta [expr 20 * $angle_between_two_chars]
  set rad_theta [expr $m_pai * $theta / 180.0]
  set w [expr (($r * sin($rad_theta)) + 2 * $font_size) * 2]
  set h [expr ($r - ($r * cos($rad_theta))) + 2 * $font_size]

  if { $orientation == 1 || $orientation == 3 } {
    set width_datetime [format "%.0f" $h]
    set height_datetime [format "%.0f" $w]
    set horizontal_center [format "%.0f" [expr $height_datetime * 0.5]]
    if { $orientation == 3 } {
      set vertical_offset $font_size
    } else {
      set vertical_offset [expr $width_datetime - $font_size]
    }
  } else {
    set width_datetime [format "%.0f" $w]
    set height_datetime [format "%.0f" $h]
    set horizontal_center [format "%.0f" [expr $width_datetime * 0.5]]
    if { $orientation == 2 } {
      set vertical_offset $font_size
    } else {
      set vertical_offset [expr $height_datetime - $font_size]
    }
  }

}

if { $display_style < 1 } {

  # Display[h

  wm minsize . $width_virt $height_virt
  wm maxsize . $width_virt $height_virt
  wm overrideredirect . 1
  wm geometry . ${width_virt}x${height_virt}

  label .l_date -textvariable buffer_date_label -font $date_font_for_virt
  label .l_time -textvariable buffer_time_label -font $time_font_for_virt

  pack .l_date .l_time -expand 1 -fill both

} else {

  # Screen[h

  wm minsize . $width_datetime $height_datetime
  wm maxsize . $width_datetime $height_datetime
  wm overrideredirect . 1
  wm attributes . -topmost yes
  wm geometry . ${width_datetime}x${height_datetime}
  wm attributes . -alpha "1" 
  wm attributes . -transparentcolor black

  set layer_id 0

  panedwindow .pw -sashwidth 0 -bg black
  pack .pw -expand 1 -fill both

  canvas .c0 -width $width_datetime -height $height_datetime
  .pw add .c0

  canvas .c1 -width $width_datetime -height $height_datetime
  .pw add .c1

  .pw forget .c1

  bind  . <Tab> "toggle_center_mark"

}

bind  . <Key-space> "wm overrideredirect . 0"
bind  . <Return> "wm overrideredirect . 1"
bind  . <Escape> "exit"
bind  . <KeyPress-q> "exit"

# display main window
wm state . normal

# [v
show_time "00"

