#########################################################################
##                                                                     ##
##  I N T E R S T E L L A R   C O N S O L E                            ##
##            Copyright (C) 2025- Misato Observatory, Wakayama, Japan  ##
##                                                                     ##
##  This software is available under the GPL (General Public License)  ##
##                                                                     ##
#########################################################################

####################################################################
##                                                                ##
##                           S P L A S H                          ##
##                                                                ##
####################################################################


set flag_mapped_splash 0

proc test_splash_window { top } {

  global flag_mapped_splash

  set status0 [winfo exists $top]

  set status1 [winfo ismapped $top]

  if { $status0 !=0 && $status1 != 0 } {
    set flag_mapped_splash 1
  } else {
    after 500 test_splash_window $top
  }

  return

}

proc show_splash { top } {

  global flag_mapped_splash

  toplevel $top
  wm overrideredirect $top 1

  image create photo splashim -file splash.gif

  label $top.lbl -image splashim -borderwidth 0

  pack $top.lbl

  wm withdraw $top
  update

  set splash_width [winfo reqwidth $top.lbl]
  set splash_height [winfo reqheight $top.lbl]

  # for debug
  #set buffer_codefield $splash_height

  #set pos_x [ expr {( [winfo vrootwidth  .] - $splash_width ) / 2 } ]
  #set pos_y [ expr {( [winfo vrootheight .] - $splash_height ) / 2 } ]
  set pos_x [ expr {( [winfo screenwidth  .] - $splash_width ) / 2 } ]
  set pos_y [ expr {( [winfo screenheight .] - $splash_height ) / 2 } ]

  wm geometry $top +$pos_x+$pos_y

  #bind $top <Map> [list test_splash_window $top]

  wm transient $top .
  wm deiconify $top
  wm state $top normal

  raise $top
  wm attributes $top -topmost yes

  update

  #######################################################################

  #after 500 test_splash_window $top
  #tkwait variable flag_mapped_splash

  return

}

#
# Main
#
if { 1 } {

  # hide default wish window
  wm state . withdrawn

  show_splash .splash

  #
  # Close Splash
  #

  set d 4000
  if { 0 < $argc } {
    set d [lindex $argv 0]
  }

  after $d exit

}

